using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using gov.va.med.vbecs.GUI.controls;
using SPECIMENTESTTHRESHOLD = gov.va.med.vbecs.Common.VbecsTables.SpecimenTestThreshold;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmMaintainComplications
	/// </summary>
	public class FrmMaintainComplications : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Form Controls

		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.TextBox txtThresholdResult;
		private System.Windows.Forms.TextBox txtLabTestName;
		private System.Windows.Forms.Label lblLabTestName;
		private System.Windows.Forms.GroupBox grpLabTests;
		private System.Windows.Forms.ListView lvLabTests;
		private System.Windows.Forms.ColumnHeader colLabTestName;
		private System.Windows.Forms.ColumnHeader colSpecimenType;
		private System.Windows.Forms.ColumnHeader colThresholdResult;
		private System.Windows.Forms.GroupBox grpDefine;
		private System.Windows.Forms.Label lblSpecimenType;
		private System.Windows.Forms.ColumnHeader colActive;
		private System.Windows.Forms.Button btnClear;
		private System.ComponentModel.IContainer components = null;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSave;
		private System.Windows.Forms.TextBox txtSpecimenType;
		private System.Windows.Forms.Button btnSelectLabTest;
		private System.Windows.Forms.CheckBox cbShowInactive;
		private System.Windows.Forms.ColumnHeader colIEN;		
		private System.Windows.Forms.RadioButton rdoNoThreshold;
		private System.Windows.Forms.RadioButton rdoNumericThreshold;
		private System.Windows.Forms.RadioButton rdoTextThreshold;
		private System.Windows.Forms.TextBox txtTextThreshold;
		private System.Windows.Forms.GroupBox grpThreshold;
		private System.Windows.Forms.GroupBox grpLabTest;

		#endregion

		private BOL.LabTest _LabTest;
		private DataTable _LabTests;
	    private bool _removeItem;

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmMaintainComplications()
		{
		    _removeItem = false;
			this.LockController.LockFunction = Common.LockFunctions.UC034MaintainTransfusionComplications;

			InitializeComponent();

			_LabTest = new BOL.LabTest();
			_LabTest.ReportType = Common.ReportType.TransfusionComplication;		
			
			_LabTests = _LabTest.GetLabTests();

			//Locking Check -- if multi users are in here at the same time, there is the chance for data corruption
			//by data corruption, I mean 2 people could add the same STT at the same time.
			//A guid will represent the entire use case, and so we lock out the UC to prevent concurrent users
			if (!this.LockUseCase())
			{
				this.DialogResult = DialogResult.Abort;
				this.Close();
				return;
			}	

			_LabTest.IsDirtyChanged += new System.EventHandler(CheckValid);
			//setting the event to fire the setdirtyflag function
			_LabTest.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
			_LabTest.Valid += new System.EventHandler(CheckValid);
			_LabTest.Invalid += new System.EventHandler(CheckValid);
			_LabTest.SetInitialBrokenRules(this.Name);
			
			_LabTests.RowChanged += new System.Data.DataRowChangeEventHandler(EnableOKButton);

			LoadLabTests();

			Clear();

			_LabTests.AcceptChanges();

			SetComponentProperties();
			//Set initial state of page to false
			this.IsDirty=false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmMaintainComplications));
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancel = new System.Windows.Forms.Button();
            this.txtThresholdResult = new System.Windows.Forms.TextBox();
            this.lvLabTests = new System.Windows.Forms.ListView();
            this.colActive = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colLabTestName = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colIEN = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colSpecimenType = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colThresholdResult = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.txtLabTestName = new System.Windows.Forms.TextBox();
            this.btnClear = new System.Windows.Forms.Button();
            this.txtSpecimenType = new System.Windows.Forms.TextBox();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.grpDefine = new System.Windows.Forms.GroupBox();
            this.grpLabTest = new System.Windows.Forms.GroupBox();
            this.lblLabTestName = new System.Windows.Forms.Label();
            this.btnSelectLabTest = new System.Windows.Forms.Button();
            this.lblSpecimenType = new System.Windows.Forms.Label();
            this.grpThreshold = new System.Windows.Forms.GroupBox();
            this.rdoNoThreshold = new System.Windows.Forms.RadioButton();
            this.rdoNumericThreshold = new System.Windows.Forms.RadioButton();
            this.txtTextThreshold = new System.Windows.Forms.TextBox();
            this.rdoTextThreshold = new System.Windows.Forms.RadioButton();
            this.btnSave = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.grpLabTests = new System.Windows.Forms.GroupBox();
            this.cbShowInactive = new System.Windows.Forms.CheckBox();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpDefine.SuspendLayout();
            this.grpLabTest.SuspendLayout();
            this.grpThreshold.SuspendLayout();
            this.grpLabTests.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(592, 30);
            this.vbecsLogo1.TabIndex = 4;
            this.vbecsLogo1.Title = "Maintain Transfusion Complication Thresholds";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 409);
            this.lblRequiredField.TabIndex = 6;
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
            this.btnOK.Location = new System.Drawing.Point(432, 388);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 2;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(512, 388);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 3;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // txtThresholdResult
            // 
            this.txtThresholdResult.AccessibleDescription = "Numeric Threshold";
            this.txtThresholdResult.AccessibleName = "Numeric Threshold";
            this.txtThresholdResult.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtThresholdResult.Enabled = false;
            this.txtThresholdResult.Location = new System.Drawing.Point(140, 40);
            this.txtThresholdResult.MaxLength = 15;
            this.txtThresholdResult.Name = "txtThresholdResult";
            this.txtThresholdResult.Size = new System.Drawing.Size(128, 20);
            this.txtThresholdResult.TabIndex = 2;
            this.txtThresholdResult.TextChanged += new System.EventHandler(this.txtThresholdResult_Leave);
            this.txtThresholdResult.Leave += new System.EventHandler(this.txtThresholdResult_Leave);
            // 
            // lvLabTests
            // 
            this.lvLabTests.AccessibleDescription = "Transfusion Complication Thresholds";
            this.lvLabTests.AccessibleName = "Transfusion Complication Thresholds";
            this.lvLabTests.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvLabTests.CheckBoxes = true;
            this.lvLabTests.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colActive,
            this.colLabTestName,
            this.colIEN,
            this.colSpecimenType,
            this.colThresholdResult});
            this.lvLabTests.FullRowSelect = true;
            this.lvLabTests.HideSelection = false;
            this.lvLabTests.Location = new System.Drawing.Point(8, 16);
            this.lvLabTests.MultiSelect = false;
            this.lvLabTests.Name = "lvLabTests";
            this.lvLabTests.Size = new System.Drawing.Size(508, 132);
            this.lvLabTests.TabIndex = 0;
            this.lvLabTests.UseCompatibleStateImageBehavior = false;
            this.lvLabTests.View = System.Windows.Forms.View.Details;
            this.lvLabTests.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvLabTests_ColumnClick);
            this.lvLabTests.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvLabTests_ItemCheck);
            this.lvLabTests.ItemChecked += new System.Windows.Forms.ItemCheckedEventHandler(this.lvLabTests_ItemChecked);
            this.lvLabTests.SelectedIndexChanged += new System.EventHandler(this.lvLabTests_SelectedIndexChanged);
            // 
            // colActive
            // 
            this.colActive.Text = "Active";
            this.colActive.Width = 45;
            // 
            // colLabTestName
            // 
            this.colLabTestName.Text = "Lab Test Name";
            this.colLabTestName.Width = 180;
            // 
            // colIEN
            // 
            this.colIEN.Text = "IEN";
            this.colIEN.Width = 40;
            // 
            // colSpecimenType
            // 
            this.colSpecimenType.Text = "Specimen Type";
            this.colSpecimenType.Width = 95;
            // 
            // colThresholdResult
            // 
            this.colThresholdResult.Text = "Threshold";
            this.colThresholdResult.Width = 95;
            // 
            // txtLabTestName
            // 
            this.txtLabTestName.AccessibleDescription = "Laboratory Test Name";
            this.txtLabTestName.AccessibleName = "Laboratory Test Name";
            this.txtLabTestName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtLabTestName.Location = new System.Drawing.Point(8, 32);
            this.txtLabTestName.Name = "txtLabTestName";
            this.txtLabTestName.ReadOnly = true;
            this.txtLabTestName.Size = new System.Drawing.Size(180, 20);
            this.txtLabTestName.TabIndex = 1;
            // 
            // btnClear
            // 
            this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClear.Location = new System.Drawing.Point(440, 152);
            this.btnClear.Name = "btnClear";
            this.btnClear.Size = new System.Drawing.Size(75, 23);
            this.btnClear.TabIndex = 3;
            this.btnClear.Text = "&Clear";
            this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
            // 
            // txtSpecimenType
            // 
            this.txtSpecimenType.AccessibleDescription = "Specimen Type";
            this.txtSpecimenType.AccessibleName = "Specimen Type";
            this.txtSpecimenType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtSpecimenType.Location = new System.Drawing.Point(8, 72);
            this.txtSpecimenType.Name = "txtSpecimenType";
            this.txtSpecimenType.ReadOnly = true;
            this.txtSpecimenType.Size = new System.Drawing.Size(176, 20);
            this.txtSpecimenType.TabIndex = 4;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 36);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(56, 348);
            this.grpImage.TabIndex = 5;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // grpDefine
            // 
            this.grpDefine.AccessibleDescription = "Define Transfusion Complication Threshold";
            this.grpDefine.AccessibleName = "Define Transfusion Complication Threshold";
            this.grpDefine.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpDefine.Controls.Add(this.grpLabTest);
            this.grpDefine.Controls.Add(this.grpThreshold);
            this.grpDefine.Controls.Add(this.btnSave);
            this.grpDefine.Controls.Add(this.btnClear);
            this.grpDefine.Location = new System.Drawing.Point(64, 36);
            this.grpDefine.Name = "grpDefine";
            this.grpDefine.Size = new System.Drawing.Size(524, 180);
            this.grpDefine.TabIndex = 0;
            this.grpDefine.TabStop = false;
            this.grpDefine.Text = "Define Transfusion Complication Threshold";
            // 
            // grpLabTest
            // 
            this.grpLabTest.AccessibleDescription = "Lab Test";
            this.grpLabTest.AccessibleName = "Lab Test";
            this.grpLabTest.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpLabTest.Controls.Add(this.lblLabTestName);
            this.grpLabTest.Controls.Add(this.txtLabTestName);
            this.grpLabTest.Controls.Add(this.btnSelectLabTest);
            this.grpLabTest.Controls.Add(this.lblSpecimenType);
            this.grpLabTest.Controls.Add(this.txtSpecimenType);
            this.grpLabTest.Location = new System.Drawing.Point(8, 16);
            this.grpLabTest.Name = "grpLabTest";
            this.grpLabTest.Size = new System.Drawing.Size(216, 132);
            this.grpLabTest.TabIndex = 0;
            this.grpLabTest.TabStop = false;
            this.grpLabTest.Text = "Lab Test*";
            // 
            // lblLabTestName
            // 
            this.lblLabTestName.Location = new System.Drawing.Point(8, 16);
            this.lblLabTestName.Name = "lblLabTestName";
            this.lblLabTestName.Size = new System.Drawing.Size(120, 16);
            this.lblLabTestName.TabIndex = 0;
            this.lblLabTestName.Text = "Laboratory Test Name";
            this.lblLabTestName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnSelectLabTest
            // 
            this.btnSelectLabTest.AccessibleDescription = "find";
            this.btnSelectLabTest.AccessibleName = "find";
            this.btnSelectLabTest.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSelectLabTest.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnSelectLabTest.Location = new System.Drawing.Point(188, 32);
            this.btnSelectLabTest.Name = "btnSelectLabTest";
            this.btnSelectLabTest.Size = new System.Drawing.Size(24, 20);
            this.btnSelectLabTest.TabIndex = 2;
            this.btnSelectLabTest.Text = "find";
            this.btnSelectLabTest.Click += new System.EventHandler(this.btnSelectLabTest_Click);
            // 
            // lblSpecimenType
            // 
            this.lblSpecimenType.Location = new System.Drawing.Point(8, 56);
            this.lblSpecimenType.Name = "lblSpecimenType";
            this.lblSpecimenType.Size = new System.Drawing.Size(120, 16);
            this.lblSpecimenType.TabIndex = 3;
            this.lblSpecimenType.Text = "Specimen Type";
            this.lblSpecimenType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpThreshold
            // 
            this.grpThreshold.AccessibleDescription = "Threshold";
            this.grpThreshold.AccessibleName = "Threshold";
            this.grpThreshold.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpThreshold.Controls.Add(this.rdoNoThreshold);
            this.grpThreshold.Controls.Add(this.rdoNumericThreshold);
            this.grpThreshold.Controls.Add(this.txtThresholdResult);
            this.grpThreshold.Controls.Add(this.txtTextThreshold);
            this.grpThreshold.Controls.Add(this.rdoTextThreshold);
            this.grpThreshold.Enabled = false;
            this.grpThreshold.Location = new System.Drawing.Point(228, 16);
            this.grpThreshold.Name = "grpThreshold";
            this.grpThreshold.Size = new System.Drawing.Size(288, 132);
            this.grpThreshold.TabIndex = 1;
            this.grpThreshold.TabStop = false;
            this.grpThreshold.Text = "Threshold*";
            // 
            // rdoNoThreshold
            // 
            this.rdoNoThreshold.AccessibleDescription = "No Threshold Include all test results";
            this.rdoNoThreshold.AccessibleName = "No Threshold Include all test results";
            this.rdoNoThreshold.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rdoNoThreshold.Checked = true;
            this.rdoNoThreshold.Location = new System.Drawing.Point(8, 16);
            this.rdoNoThreshold.Name = "rdoNoThreshold";
            this.rdoNoThreshold.Size = new System.Drawing.Size(268, 20);
            this.rdoNoThreshold.TabIndex = 0;
            this.rdoNoThreshold.TabStop = true;
            this.rdoNoThreshold.Text = "No Threshold (Include &all test results.)";
            this.rdoNoThreshold.CheckedChanged += new System.EventHandler(this.NoThresholdChanged);
            // 
            // rdoNumericThreshold
            // 
            this.rdoNumericThreshold.Location = new System.Drawing.Point(8, 40);
            this.rdoNumericThreshold.Name = "rdoNumericThreshold";
            this.rdoNumericThreshold.Size = new System.Drawing.Size(128, 20);
            this.rdoNumericThreshold.TabIndex = 1;
            this.rdoNumericThreshold.Text = "&Numeric Threshold";
            this.rdoNumericThreshold.CheckedChanged += new System.EventHandler(this.NumericThresholdChanged);
            // 
            // txtTextThreshold
            // 
            this.txtTextThreshold.AccessibleDescription = "Positive Results Enter all terms relating to a positive test result separated by " +
    "commas";
            this.txtTextThreshold.AccessibleName = "Positive Results Enter all terms relating to a positive test result separated by " +
    "commas";
            this.txtTextThreshold.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtTextThreshold.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
            this.txtTextThreshold.Enabled = false;
            this.txtTextThreshold.Location = new System.Drawing.Point(140, 64);
            this.txtTextThreshold.MaxLength = 255;
            this.txtTextThreshold.Multiline = true;
            this.txtTextThreshold.Name = "txtTextThreshold";
            this.txtTextThreshold.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.txtTextThreshold.Size = new System.Drawing.Size(128, 60);
            this.txtTextThreshold.TabIndex = 4;
            this.txtTextThreshold.TextChanged += new System.EventHandler(this.txtTextThreshold_TextChanged);
            // 
            // rdoTextThreshold
            // 
            this.rdoTextThreshold.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.rdoTextThreshold.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.rdoTextThreshold.Location = new System.Drawing.Point(8, 64);
            this.rdoTextThreshold.Name = "rdoTextThreshold";
            this.rdoTextThreshold.Size = new System.Drawing.Size(142, 60);
            this.rdoTextThreshold.TabIndex = 3;
            this.rdoTextThreshold.TabStop = true;
            this.rdoTextThreshold.Text = "&Positive Result(s) (Enter all terms relating to a positive test result, separate" +
    "d by commas.)";
            this.rdoTextThreshold.TextAlign = System.Drawing.ContentAlignment.TopLeft;
            this.rdoTextThreshold.CheckedChanged += new System.EventHandler(this.TextThresholdChanged);
            // 
            // btnSave
            // 
            this.btnSave.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSave.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnSave.Image = ((System.Drawing.Image)(resources.GetObject("btnSave.Image")));
            this.btnSave.Location = new System.Drawing.Point(360, 152);
            this.btnSave.Name = "btnSave";
            this.btnSave.Size = new System.Drawing.Size(75, 23);
            this.btnSave.TabIndex = 2;
            this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
            this.btnSave.MouseHover += new System.EventHandler(this.btnSave_MouseHover);
            // 
            // grpLabTests
            // 
            this.grpLabTests.AccessibleDescription = "Transfusion Complication Thresholds";
            this.grpLabTests.AccessibleName = "Transfusion Complication Thresholds";
            this.grpLabTests.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpLabTests.Controls.Add(this.cbShowInactive);
            this.grpLabTests.Controls.Add(this.lvLabTests);
            this.grpLabTests.Location = new System.Drawing.Point(64, 216);
            this.grpLabTests.Name = "grpLabTests";
            this.grpLabTests.Size = new System.Drawing.Size(524, 168);
            this.grpLabTests.TabIndex = 1;
            this.grpLabTests.TabStop = false;
            this.grpLabTests.Text = "Transfusion Complication Thresholds";
            // 
            // cbShowInactive
            // 
            this.cbShowInactive.AccessibleDescription = "Show Inactive Transfusion Complication Thresholds";
            this.cbShowInactive.AccessibleName = "Show Inactive Transfusion Complication Thresholds";
            this.cbShowInactive.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbShowInactive.Location = new System.Drawing.Point(8, 148);
            this.cbShowInactive.Name = "cbShowInactive";
            this.cbShowInactive.Size = new System.Drawing.Size(504, 16);
            this.cbShowInactive.TabIndex = 1;
            this.cbShowInactive.Text = "&Show Inactive Transfusion Complication Thresholds.";
            this.cbShowInactive.CheckedChanged += new System.EventHandler(this.cbShowInactive_CheckedChanged);
            // 
            // FrmMaintainComplications
            // 
            this.AcceptButton = this.btnSave;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(592, 423);
            this.Controls.Add(this.grpLabTests);
            this.Controls.Add(this.grpDefine);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.hlphelpChm.SetHelpKeyword(this, "Transfusion_Complications.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 450);
            this.Name = "FrmMaintainComplications";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Transfusion Complication Thresholds";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmMaintainComplications_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.grpDefine, 0);
            this.Controls.SetChildIndex(this.grpLabTests, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpDefine.ResumeLayout(false);
            this.grpLabTest.ResumeLayout(false);
            this.grpLabTest.PerformLayout();
            this.grpThreshold.ResumeLayout(false);
            this.grpThreshold.PerformLayout();
            this.grpLabTests.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Methods

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/18/2003</CreationDate>
		///
		/// <summary>
		/// Private function to return indication of user's authority to access function
		/// </summary>
		/// <returns></returns>
		private bool HasAuthority()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.EditConsultativeReports );
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/3/2002</CreationDate>
		///	
		/// <summary>
		/// Private method to set properties of user controls.
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC034.FrmMaintainComplications());
			//
			this.btnSave.Text = "&Add";
			this.btnSave.EnabledButton = false;
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);	
		}

		private void SetToolTips()
		{
			this.SetThisToolTip(this.txtLabTestName, Common.StrRes.Tooltips.UC033.LabTestName("Complications"));
			this.SetThisToolTip(this.txtSpecimenType, Common.StrRes.Tooltips.UC033.SpecimenType());
			this.SetThisToolTip(this.btnSelectLabTest, Common.StrRes.Tooltips.UC033.LabTestSearch("Complications"));
			//
			this.SetThisToolTip(this.rdoNoThreshold, Common.StrRes.Tooltips.UC033.NoThreshold());
			this.SetThisToolTip(this.rdoNumericThreshold, Common.StrRes.Tooltips.UC033.NumericThreshold());
			this.SetThisToolTip(this.txtThresholdResult, Common.StrRes.Tooltips.UC034.EnterThresholdResult());
			this.SetThisToolTip(this.rdoTextThreshold, Common.StrRes.Tooltips.UC033.PositiveThreshold());
			this.SetThisToolTip(this.txtTextThreshold, Common.StrRes.Tooltips.UC034.TextThreshold());
			//
			this.SetThisToolTip(this.lvLabTests, Common.StrRes.Tooltips.UC034.TransfusionComplications());
			this.SetThisToolTip(this.cbShowInactive, Common.StrRes.Tooltips.Common.ShowInactive("transfusion complication test thresholds"));
			this.SetThisToolTip(this.btnClear,Common.StrRes.Tooltips.Common.ClearEntries());
			//
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.ClickToDisregardChangesAndReturn());
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/3/2002</CreationDate>
		///
		/// <summary>
		/// Loads the initial lab test parameters into the listview.
		/// </summary>
		private void LoadLabTests()
		{
			lvLabTests.Items.Clear();
			foreach(DataRow dr in _LabTests.Rows)
			{
				AddLabTestToListView(dr);
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvLabTests);
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/3/2002</CreationDate>
		///
		///<summary>
		/// Overloaded method to add details from a data row to the lab test listview.
		///</summary>
		private void AddLabTestToListView(DataRow dr)
		{
			if ((Convert.ToChar(dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode]) == Convert.ToChar(Common.RecordStatusCode.Inactive))&&
				(!this.cbShowInactive.Checked))
			{
				//Don't add if inactive and checkbox unchecked
				return;
			}
			else
			{
				ListViewItem lvi = new ListViewItem();
				lvi.Tag = dr;
				lvi.Checked = (Convert.ToChar(dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode]) == Convert.ToChar(Common.RecordStatusCode.Active));
				lvi.SubItems.Add(dr[Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName].ToString());
				lvi.SubItems.Add(dr[Common.VbecsTables.SpecimenTestThreshold.LabTestId].ToString());
				lvi.SubItems.Add(((Common.SpecimenType)Convert.ToInt32(Convert.ToChar(dr[Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode].ToString().Trim()))).ToString());
				lvi.SubItems.Add(dr[Common.VbecsTables.SpecimenTestThreshold.ThresholdResult].ToString());
				//
				if (lvi.Checked)
				{
					lvi.ForeColor = lvLabTests.ForeColor;
				}
				else
				{
					lvi.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
				}
				//
				lvLabTests.Items.Add(lvi);
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/3/2002</CreationDate>
		///
		///<summary>
		/// Overloaded method to add details from a lab test object to the lab test listview.
		///</summary>
		private void AddLabTestToListView()
		{
			_LabTest.ReportType = Common.ReportType.TransfusionComplication;

			DataRow dr = _LabTest.LoadDataRowFromThis(_LabTests.NewRow());

			_LabTests.Rows.Add(dr);

		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/3/2002</CreationDate>
		///
		///<summary>
		/// Checks for an existing lab test and load the object if it exists.
		///</summary>
		///<param name="labTestName">string</param>
		private void CheckExistingLabTests(string labTestName)
		{
			foreach(DataRow dr in this._LabTests.Rows)
			{
				if (dr[Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName].ToString().ToUpper().Trim() == labTestName.ToUpper().Trim())
				{
					this._LabTest = new BOL.LabTest(dr);
					this._LabTest.IsDirtyChanged += new System.EventHandler(CheckValid);
					//setting the event to fire the setdirtyflag function
					this._LabTest.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
					this._LabTest.Valid += new System.EventHandler(CheckValid);
					this._LabTest.Invalid += new System.EventHandler(CheckValid);
					this._LabTest.IsNew = false;
					this._LabTest.IsDirty = true;
					return;
				}
			}
			
			this._LabTest.Clear();
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/3/2002</CreationDate>
		///
		///<summary>
		/// Populates the form with the lab test parameters from the lab test object.
		///</summary>
		private void PopulateForm()
		{
			txtLabTestName.Text = _LabTest.LabTestName;
			if (_LabTest.SpecimenType == Common.SpecimenType.Unknown)
			{
				txtSpecimenType.Text = "";
			}
			else
			{
				txtSpecimenType.Text = _LabTest.SpecimenType.ToString();
			}
			//
			this.grpThreshold.Enabled = true;
			//
			this.rdoNumericThreshold.Checked = (this._LabTest.ThresholdType == Common.ThresholdType.Numeric);
			this.rdoTextThreshold.Checked = (this._LabTest.ThresholdType == Common.ThresholdType.Text);
			this.rdoNoThreshold.Checked = (this._LabTest.ThresholdType == Common.ThresholdType.None);
			//
			if (_LabTest.IsNew)
			{
				this.btnSave.Text = "&Add";
			}
			else
			{
				this.btnSave.Text = "&Update";
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/3/2002</CreationDate>
		///
		///<summary>
		/// Clears the form of the lab test parameter being added.
		///</summary>
		private void Clear()
		{
			_LabTest.Clear();
			PopulateForm();
			
			this.txtTextThreshold.Text = "";
			this.txtThresholdResult.Text = "";
			this.rdoNoThreshold.Checked = true;
			this.grpThreshold.Enabled = false;

			errError.SetVbecsError(txtSpecimenType, ""); // **** 508 Compliance ***
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/3/2002</CreationDate>
		///
		///<summary>
		/// Updates an existing lab test parameter in the listview and datatable.
		///</summary>
		private void UpdateLabTestInListView()
		{
			foreach(DataRow dr in this._LabTests.Rows)
			{
				if (dr[Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName].ToString().ToUpper().Trim() == _LabTest.LabTestName.ToUpper().Trim())
				{
					dr[Common.VbecsTables.SpecimenTestThreshold.LabTestId] = _LabTest.LabTestId;
					dr[Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode] = Convert.ToChar(_LabTest.SpecimenType); 
					dr[Common.VbecsTables.SpecimenTestThreshold.ThresholdResult] = _LabTest.Threshold;
					dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);//_LabTest.RecordStatusCode);
					dr[Common.VbecsTables.SpecimenTestThreshold.LastUpdateUser] = ThisUser.UserNTLoginID;
					//
					return;
				}
			}
		}
		#endregion

		#region Events

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///
		///<summary>
		/// Threshold result leave event handler.  Sets an error message for invalid entry or the object's
		/// threshold result for valid entries.
		///</summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void txtThresholdResult_Leave(object sender, System.EventArgs e)
		{
			if (_LabTest.ThresholdType == Common.ThresholdType.Numeric)
			{
				if (txtThresholdResult.Text.Trim().Length==0)
				{
					errError.SetVbecsError(txtThresholdResult, ""); // **** 508 Compliance ***
					_LabTest.Threshold = "";
					return;
				}
				if (((txtThresholdResult.Text.Trim().Length>2)&&(txtThresholdResult.Text.StartsWith("> ")||txtThresholdResult.Text.StartsWith("< ")))||
					((txtThresholdResult.Text.Trim().Length>1)&&(txtThresholdResult.Text.StartsWith(">")||txtThresholdResult.Text.StartsWith("<"))))
				{
					try
					{
						_LabTest.Threshold = txtThresholdResult.Text;
						errError.SetVbecsError(txtThresholdResult, ""); // **** 508 Compliance ***
					}
					catch(BOL.BusinessObjectException)
					{
						this.errError.SetVbecsError(this.txtThresholdResult, Common.StrRes.Tooltips.UC050.NumericThreshold().ResString); // **** 508 Compliance ***
						_LabTest.Threshold = "";
						return;
					}
				}
				else if ((txtThresholdResult.Text.Trim().Length>0)&&(txtThresholdResult.Text.StartsWith(">")||txtThresholdResult.Text.StartsWith("<")))
				{
					_LabTest.Threshold = "";
					errError.SetVbecsError(txtThresholdResult, ""); // **** 508 Compliance ***
					return;
				}
				else
				{
					_LabTest.Threshold = "";
					this.errError.SetVbecsError(this.txtThresholdResult, Common.StrRes.Tooltips.UC050.NumericThreshold().ResString); // **** 508 Compliance ***
					return;
				}
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///
		///<summary>
		/// Broken rules and IsDirty change event handler. Enables save button if data is valid and has changed.
		///</summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void CheckValid(object sender, System.EventArgs e)
		{
			if ((this._LabTest.IsValid) && (this._LabTest.IsDirty))
			{
				btnSave.SetToolTip(Common.StrRes.Tooltips.UC034.SaveTransfusionCompliance().ResString);				btnSave.EnabledButton = true;
			}
			else
			{
				btnSave.EnabledButton = false;
			}
		}
		
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///
		///<summary>
		/// Save button click event handler. Adds or updates transfusion compliance parameter to listview, then clears screen.
		///</summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void btnSave_Click(object sender, System.EventArgs e)
		{
			if (_LabTest.IsNew)
			{
				AddLabTestToListView();
			}
			else
			{
				UpdateLabTestInListView();
			}
			this.LoadLabTests();
			Clear();
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///
		///<summary>
		/// Save button mouse hover event handler. Displays broken rules as tool tip.
		///</summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void btnSave_MouseHover(object sender, System.EventArgs e)
		{
			System.Text.StringBuilder _str = new System.Text.StringBuilder();

			if (_LabTest.GetBrokenRulesMessage(this.Name).Length == 0) 
			{
				if (_LabTest.IsDirty == false)
				{
					_str.Append("Cannot save - transfusion compliance parameter has not changed");
				}
				else
				{
					_str.Append("Click button to add or update transfusion compliance report parameter");
				}
			}
			else
			{
				_str.Append(_LabTest.GetBrokenRulesMessage(this.Name));
			}

			btnSave.SetToolTip(_str.ToString());
		}
	
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///
		/// <summary>
		///  Listview event handler. Loads selected row into UI controls for possible editing.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvLabTests_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.Clear();
			//
			if (this.lvLabTests.SelectedItems.Count > 0)
			{
				//
				DataRow dr = (DataRow)this.lvLabTests.SelectedItems[0].Tag;
				//
				this._LabTest = new BOL.LabTest();
				this._LabTest.IsDirtyChanged += new System.EventHandler(CheckValid);
				//setting the event to fire the setdirtyflag function
				this._LabTest.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
				this._LabTest.Valid += new System.EventHandler(CheckValid);
				this._LabTest.Invalid += new System.EventHandler(CheckValid);
				this._LabTest.SetInitialBrokenRules(this.Name);
				this._LabTest.ReportType = Common.ReportType.TransfusionComplication;
				this._LabTest.SpecimenTestThresholdGuid = (Guid)dr[Common.VbecsTables.SpecimenTestThreshold.SpecimenTestThresholdGuid];
				this._LabTest.LabTestId = Convert.ToInt32(dr[Common.VbecsTables.SpecimenTestThreshold.LabTestId].ToString().Trim());
				this._LabTest.LabTestName = dr[Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName].ToString();
				this._LabTest.SpecimenType = ((Common.SpecimenType)Convert.ToInt32(Convert.ToChar(dr[Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode].ToString().Trim())));
				if (Common.RegularExpressions.ThresholdText().IsMatch(dr[Common.VbecsTables.SpecimenTestThreshold.ThresholdResult].ToString()))
				{
					this._LabTest.ThresholdType = Common.ThresholdType.Text;
				}
				else if (Common.RegularExpressions.Threshold().IsMatch(dr[Common.VbecsTables.SpecimenTestThreshold.ThresholdResult].ToString()))
				{
					this._LabTest.ThresholdType = Common.ThresholdType.Numeric;
				}
				else
				{
					this._LabTest.ThresholdType = Common.ThresholdType.None;
				}
				this._LabTest.Threshold = dr[Common.VbecsTables.SpecimenTestThreshold.ThresholdResult].ToString();
				this._LabTest.RecordStatusCode = Common.Utility.GetRecordStatusCodeFromString(dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode].ToString());
				this._LabTest.IsNew = false;
				this._LabTest.IsDirty = false;
				//
				PopulateForm();
			}
			this.SpeakListViewWithCheckBox(lvLabTests);
		}
		
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///
		/// <summary>
		///  Listview column click event handler. Sorts the listview by the selected column.
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">ColumnClickEventArgs</param>
		private void lvLabTests_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 2)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvLabTests.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.Integer);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvLabTests.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}
	
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///
		/// <summary>
		/// List view check box change event handler. Updates data row with new record status value.
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">ItemCheckEventArgs</param>
		private void lvLabTests_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			DataRow dr = (DataRow)lvLabTests.Items[e.Index].Tag;

			if (dr.Table.Columns.Contains(Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode))
			{
				if (e.NewValue == CheckState.Checked)
				{
					//Ensure that it is actually changing - to maintain GetChanges() integrity
					if (System.Convert.ToChar(dr[Common.VbecsTables.RecordStatus.RecordStatusCode].ToString()) != Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active))
					{
						dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
						lvLabTests.Items[e.Index].ForeColor = lvLabTests.ForeColor;
						lvLabTests.Items[e.Index].Selected = true;
					}
				}
				else
				{
					//Ensure that it is actually changing - to maintain GetChanges() integrity
					if (System.Convert.ToChar(dr[Common.VbecsTables.RecordStatus.RecordStatusCode].ToString()) != Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive))
					{
						dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive);
						lvLabTests.Items[e.Index].ForeColor = Color.FromKnownColor(KnownColor.GrayText);
						//
						if (!this.cbShowInactive.Checked)
						{
						    _removeItem = true;
						}
						else
						{
							lvLabTests.Items[e.Index].Selected = true;
						}
					}
				}		
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///
		/// <summary>
		/// Clear button click event hanlder. Calls Clear method.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			this.Clear();
			this.lvLabTests.SelectedItems.Clear();
			this.btnSelectLabTest.Focus();
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///
		///<summary>
		/// Data row change event handler. Enables OK button to allow saving of changed information.
		///</summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void EnableOKButton(object sender, System.Data.DataRowChangeEventArgs e)
		{
			btnOK.EnabledButton = true;
			btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			//something on the form was changed, it is now dirty.
			this.IsDirty=true;
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///
		///<summary>
		/// Save button click event hanlder. Saves all the changed entries in lab test parameter table to the database.
		///</summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("transfusion complication"));
			if (_saveResult == DialogResult.Yes)
			{
				try
				{
					_LabTest.SaveLabTests(_LabTests,Common.UpdateFunction.UC034FrmMaintainComplications);
				}
				catch (Common.RowVersionException)
				{
					this.btnOK.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				}
				//Finished updating or attempting to update, close window.
				this.IsDirty=false;
				this.Close();
			}		
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/4/2002</CreationDate>
		///
		///<summary>
		/// Clear button click event hanlder. Calls the Clear method.
		///</summary>
		///<param name="sender">object</param>
		///<param name="e">System.EventArgs</param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			Close();
		}

		private void btnSelectLabTest_Click(object sender, System.EventArgs e)
		{
			DlgSelectLabTest dlg = new DlgSelectLabTest(false, Common.ReportType.TransfusionComplication);

			dlg.ShowDialogFromLockedParent(this,false);
            
            if (dlg.DialogResult != DialogResult.OK)
			{
				return;
			}
			//
			DataTable dt = dlg.SelectedLabTests;
			if (dt.Rows.Count == 1)
			{
				//foreach(ListViewItem lvi in this.lvLabTests.Items)
				foreach(DataRow dr in this._LabTests.Rows)
				{
					//DataRow dr = (DataRow)lvi.Tag;
					if (dr[Common.VbecsTables.SpecimenTestThreshold.LabTestId].ToString().Trim() == dt.Rows[0][Common.VbecsTables.SpecimenTestThreshold.LabTestId].ToString().Trim())
					{
						bool found = false;
						foreach(ListViewItem lvi in this.lvLabTests.Items)
						{
							if ((DataRow)lvi.Tag == dr)
							{
								lvi.Selected = true;
								this._LabTest.SpecimenType = ((Common.SpecimenType)Convert.ToInt32(Convert.ToChar(dt.Rows[0][Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode].ToString().Trim())));
								this.PopulateForm();
								found = true;
								break;
							}
						}
						if (!found)
						{
							//May need to just activate currently inactive row...
							dr[Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode] = dt.Rows[0][Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode];
							dr[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
							this.AddLabTestToListView(dr);
							this._LabTest.IsDirty = true;

						}
						return;
					}
				}
				this._LabTest = new BOL.LabTest();
				this._LabTest.IsDirtyChanged += new System.EventHandler(CheckValid);
				//setting the event to fire the setdirtyflag function
				this._LabTest.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
				this._LabTest.Valid += new System.EventHandler(CheckValid);
				this._LabTest.Invalid += new System.EventHandler(CheckValid);
				this._LabTest.SetInitialBrokenRules(this.Name);
				this._LabTest.ReportType = Common.ReportType.TransfusionComplication;
				this._LabTest.IsNew = true;
				this._LabTest.SpecimenTestThresholdGuid = Guid.NewGuid();
				this._LabTest.LabTestId = Convert.ToInt32(dt.Rows[0][Common.VbecsTables.SpecimenTestThreshold.LabTestId].ToString().Trim());
				this._LabTest.LabTestName = dt.Rows[0][Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName].ToString();
				this._LabTest.SpecimenType = ((Common.SpecimenType)Convert.ToInt32(Convert.ToChar(dt.Rows[0][Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode].ToString().Trim())));
				this._LabTest.ThresholdType = Common.ThresholdType.None;
				this._LabTest.RecordStatusCode = Common.RecordStatusCode.Active;
				this.PopulateForm();
			}
		}

		private void cbShowInactive_CheckedChanged(object sender, System.EventArgs e)
		{
			this.LoadLabTests();
		}

		private string BuildTextThreshold(string unformattedString)
		{
			string[] words = unformattedString.Split(new char[] {','});
			if (words.Length>25)
			{
				throw new BOL.BusinessObjectException();
			}
			string formattedString = "";
			foreach (string word in words)
			{
				if (word.Trim().Length>0)
				{
					formattedString += word.Trim()+",";
				}
			}
			if (formattedString.EndsWith(","))
			{
				formattedString = formattedString.Substring(0,formattedString.Length-1);
			}
			//
			return formattedString;
		}

		private void txtTextThreshold_TextChanged(object sender, System.EventArgs e)
		{
			if (_LabTest.ThresholdType == Common.ThresholdType.Text)
			{
				try
				{
					_LabTest.Threshold = BuildTextThreshold(txtTextThreshold.Text);
					errError.SetVbecsError(txtTextThreshold, ""); // **** 508 Compliance ***
				}
				catch(BOL.BusinessObjectException)
				{
					this.errError.SetVbecsError(this.txtTextThreshold, Common.StrRes.Tooltips.UC034.TextThreshold().ResString); // **** 508 Compliance ***
					_LabTest.Threshold = "";
					return;
				}
			}
		}

		private void NoThresholdChanged(object sender, System.EventArgs e)
		{
			if (this.rdoNoThreshold.Checked)
			{
				this._LabTest.ThresholdType = Common.ThresholdType.None;
				this._LabTest.Threshold = "";
				this.txtTextThreshold.Text = "";
				this.txtTextThreshold.Enabled = false;
				this.errError.SetVbecsError(this.txtTextThreshold, ""); // **** 508 Compliance ***
				this.txtThresholdResult.Text = "";
				this.txtThresholdResult.Enabled = false;
				this.errError.SetVbecsError(this.txtThresholdResult, ""); // **** 508 Compliance ***
			}
		}

		private void NumericThresholdChanged(object sender, System.EventArgs e)
		{
			if (this.rdoNumericThreshold.Checked)
			{
				this._LabTest.ThresholdType = Common.ThresholdType.Numeric;
				this.txtTextThreshold.Text = "";
				this.txtTextThreshold.Enabled = false;
				this.errError.SetVbecsError(this.txtTextThreshold, ""); // **** 508 Compliance ***
				if (Common.RegularExpressions.Threshold().IsMatch(this._LabTest.Threshold))
				{
					this.txtThresholdResult.Text = _LabTest.Threshold;
				}
				this.txtThresholdResult.Enabled = true;
				this.errError.SetVbecsError(this.txtThresholdResult, ""); // **** 508 Compliance ***
			}
		}

		private void TextThresholdChanged(object sender, System.EventArgs e)
		{
			if (this.rdoTextThreshold.Checked)
			{
				this._LabTest.ThresholdType = Common.ThresholdType.Text;
				this.txtThresholdResult.Text = "";
				this.txtThresholdResult.Enabled = false;
				this.errError.SetVbecsError(this.txtThresholdResult, ""); // **** 508 Compliance ***
				if (Common.RegularExpressions.ThresholdText().IsMatch(this._LabTest.Threshold))
				{
					this.txtTextThreshold.Text = this._LabTest.Threshold;
				}
				this.txtTextThreshold.Enabled = true;
				this.errError.SetVbecsError(this.txtTextThreshold, ""); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmMaintainComplications_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			textToSpeak = this.btnOK.EnabledButton ? null : this.btnOK.GetToolTip();
			//
			this.SpeakMessage( textToSpeak );
		}

		#endregion

        private void lvLabTests_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            if (_removeItem)
            {
                ((ListView)sender).Items.Remove(e.Item);
                _removeItem = false;
            }
        }
	}
}

